<?php

error_reporting(0);

require_once("Rest.inc.php");

class API extends REST
{

	public $data = "";
	const demo_version = false;

	private $db 	= NULL;
	private $mysqli = NULL;
	public function __construct()
	{
		// Init parent contructor
		parent::__construct();
		// Initiate Database connection
		$this->dbConnect();
	}

	/*
		 *  Connect to Database
		*/
	private function dbConnect()
	{
		require_once("../includes/config.php");
		$this->mysqli = new mysqli($host, $user, $pass, $database);
		$this->mysqli->query('SET CHARACTER SET utf8mb4');
	}

	/*
		 * Dynmically call the method based on the query string
		 */
	public function processApi()
	{
		$func = strtolower(trim(str_replace("/", "", $_REQUEST['x'])));
		if ((int)method_exists($this, $func) > 0)
			$this->$func();
		else
			$this->response('Ooops, no method found!', 404); // If the method not exist with in this class "Page not found".
	}

	/* Api Checker */
	public function check_connection()
	{
		if (mysqli_ping($this->mysqli)) {
			//echo "Responses : Congratulations, database successfully connected.";
			$respon = array(
				'status' => 'ok', 'database' => 'connected'
			);
			$this->response($this->json($respon), 200);
		} else {
			$respon = array(
				'status' => 'failed', 'database' => 'not connected'
			);
			$this->response($this->json($respon), 404);
		}
	}

	public function get_categories()
	{
		include "../includes/config.php";

		if ($this->get_request_method() != "GET") $this->response('', 406);

		$query = "SELECT * FROM categories ORDER BY id DESC";
		$data = $this->get_list_result($query);

		$this->response($this->json($data), 200);
	}

	public function get_channels_by_cat()
	{
		include "../includes/config.php";

		$id = $_GET['id'];
		if ($this->get_request_method() != "GET") $this->response('', 406);

		if (isset($id)) {
			$query = "SELECT * FROM channels WHERE cid = $id";
			$data = $this->get_list_result($query);
			$count = count($data);

			if ($count > 0) {
				$this->response($this->json($data), 200);
			} else {
				die('Oops, ID is Incorrect!');
			}
		} else {
			die('Forbidden, ID is Required!');
		}
	}

	public function get_channel()
	{
		include "../includes/config.php";

		$id = $_GET['id'];

		$query = "SELECT * FROM channels WHERE id = $id";
		$data = $this->get_list_result($query);

		$this->response($this->json($data), 200);
	}

	public function get_matchs()
	{
		include "../includes/config.php";

		if ($this->get_request_method() != "GET") $this->response('', 406);

		$query = "SELECT * FROM matchs ORDER BY start_time";
		$data = $this->get_list_result($query);

		$query2 = "SELECT match_id, title, url FROM servers";
		$data2 = $this->get_list_result($query2);

		$all_data = array();

		for ($i = 0; $i < count($data); $i++) {
			$new_obj = array();

			foreach ($data[$i] as $key => $value) {
				$new_obj[$key] = $value;
			}

			$links = array();

			for ($j = 0; $j < count($data2); $j++) {
				if ($data2[$j]['match_id'] == $new_obj['id']) {
					$new_link = array();
					$new_link['server_name'] = $data2[$j]['title'];
					$new_link['server_url'] = $data2[$j]['url'];

					$links[] = $new_link;
				}
			}

			$new_obj['links'] = $links;

			$all_data[] = $new_obj;
		}

		$this->response($this->json($all_data), 200);
	}

	public function get_search_results()
	{

		include "../includes/config.php";
		$setting_qry    = "SELECT * FROM tbl_settings WHERE id = '1'";
		$setting_result = mysqli_query($connect, $setting_qry);
		$settings_row   = mysqli_fetch_assoc($setting_result);
		$api_key    = $settings_row['api_key'];

		if (isset($_GET['api_key'])) {

			$access_key_received = $_GET['api_key'];

			if ($access_key_received == $api_key) {

				$search = $_GET['search'];

				if ($this->get_request_method() != "GET") $this->response('', 406);
				$limit = isset($this->_request['count']) ? ((int)$this->_request['count']) : 10;
				$page = isset($this->_request['page']) ? ((int)$this->_request['page']) : 1;

				$offset = ($page * $limit) - $limit;
				$count_total = $this->get_count_result("SELECT COUNT(DISTINCT n.id) FROM tbl_channel n, tbl_category c WHERE n.category_id = c.cid AND (n.channel_name LIKE '%$search%' OR n.channel_description LIKE '%$search%')");

				$query = "SELECT distinct 
								n.id AS 'channel_id',
								n.category_id,
								n.channel_name, 
								n.channel_image, 
								n.channel_url,
								n.channel_description,
								n.channel_type,
								n.video_id,
								c.category_name,
								n.user_agent
								
							FROM 
								tbl_channel n, 
								tbl_category c 
								
							WHERE n.category_id = c.cid AND (n.channel_name LIKE '%$search%' OR n.channel_description LIKE '%$search%') 

							LIMIT $limit OFFSET $offset";

				$post = $this->get_list_result($query);
				$count = count($post);
				$respon = array(
					'status' => 'ok', 'count' => $count, 'count_total' => $count_total, 'pages' => $page, 'posts' => $post
				);
				$this->response($this->json($respon), 200);
			} else {
				die('Oops, API Key is Incorrect!');
			}
		} else {
			die('Forbidden, API Key is Required!');
		}
	}

	public function get_search_results_rtl()
	{

		include "../includes/config.php";
		$setting_qry    = "SELECT * FROM tbl_settings WHERE id = '1'";
		$setting_result = mysqli_query($connect, $setting_qry);
		$settings_row   = mysqli_fetch_assoc($setting_result);
		$api_key    = $settings_row['api_key'];

		if (isset($_GET['api_key'])) {

			$access_key_received = $_GET['api_key'];

			if ($access_key_received == $api_key) {

				$search = $_GET['search'];

				if ($this->get_request_method() != "GET") $this->response('', 406);
				$limit = isset($this->_request['count']) ? ((int)$this->_request['count']) : 10;
				$page = isset($this->_request['page']) ? ((int)$this->_request['page']) : 1;

				$offset = ($page * $limit) - $limit;
				$count_total = $this->get_count_result("SELECT COUNT(DISTINCT n.id) FROM tbl_channel n, tbl_category c WHERE n.category_id = c.cid AND (n.channel_name LIKE N'%$search%' OR n.channel_description LIKE N'%$search%')");

				$query = "SELECT distinct 
								n.id AS 'channel_id',
								n.category_id,
								n.channel_name, 
								n.channel_image, 
								n.channel_url,
								n.channel_description,
								n.channel_type,
								n.video_id,
								c.category_name,
								n.user_agent
								
							FROM 
								tbl_channel n, 
								tbl_category c 
								
							WHERE n.category_id = c.cid AND (n.channel_name LIKE N'%$search%' OR n.channel_description LIKE N'%$search%') 

							LIMIT $limit OFFSET $offset";

				$post = $this->get_list_result($query);
				$count = count($post);
				$respon = array(
					'status' => 'ok', 'count' => $count, 'count_total' => $count_total, 'pages' => $page, 'posts' => $post
				);
				$this->response($this->json($respon), 200);
			} else {
				die('Oops, API Key is Incorrect!');
			}
		} else {
			die('Forbidden, API Key is Required!');
		}
	}

	public function get_settings()
	{
		include "../includes/config.php";

		if ($this->get_request_method() != "GET") $this->response('', 406);

		$query =
			"SELECT	s.application_id,
						s.version_name,
						s.external_player,
						s.external_player_id,
						s.onesignal_id,
						s.privacy_policy
				FROM settings s WHERE id = 1";

		$query2 = "SELECT * FROM ads WHERE id = 1";

		$result = $this->get_one_result($query);

		$result["ads"] = $this->get_one_result($query2);

		$this->response($this->json($result), 200);
	}

	public function get_ads()
	{
		include "../includes/config.php";

		if ($this->get_request_method() != "GET") $this->response('', 406);

		$query = "SELECT * FROM tbl_ads WHERE id = 1";

		$result = $this->get_one_result($query);
		$respon = array(
			'status' => 'ok',
			'ads' => $result
		);

		$this->response($this->json($respon), 200);
	}


	//don't edit all the code below
	private function get_list($query)
	{
		$r = $this->mysqli->query($query) or die($this->mysqli->error . __LINE__);
		if ($r->num_rows > 0) {
			$result = array();
			while ($row = $r->fetch_assoc()) {
				$result[] = $row;
			}
			$this->response($this->json($result), 200); // send user details
		}
		$this->response('', 204);	// If no records "No Content" status
	}

	private function get_list_result($query)
	{
		$result = array();
		$r = $this->mysqli->query($query) or die($this->mysqli->error . __LINE__);
		if ($r->num_rows > 0) {
			while ($row = $r->fetch_assoc()) {
				$result[] = $row;
			}
		}
		return $result;
	}

	private function get_object_result($query)
	{
		$result = array();
		$r = $this->mysqli->query($query) or die($this->mysqli->error . __LINE__);
		if ($r->num_rows > 0) {
			while ($row = $r->fetch_assoc()) {
				$result = $row;
			}
		}
		return $result;
	}

	private function get_category_result($query)
	{
		$result = array();
		$r = $this->mysqli->query($query) or die($this->mysqli->error . __LINE__);
		if ($r->num_rows > 0) {
			while ($row = $r->fetch_assoc()) {
				$result = $row;
			}
		}
		return $result;
	}

	private function get_one_result($query)
	{
		$result = array();
		$r = $this->mysqli->query($query) or die($this->mysqli->error . __LINE__);
		if ($r->num_rows > 0) $result = $r->fetch_assoc();
		return $result;
	}

	private function get_one($query)
	{
		$r = $this->mysqli->query($query) or die($this->mysqli->error . __LINE__);
		if ($r->num_rows > 0) {
			$result = $r->fetch_assoc();
			$this->response($this->json($result), 200); // send user details
		}
		$this->response('', 204);	// If no records "No Content" status
	}

	private function get_count($query)
	{
		$r = $this->mysqli->query($query) or die($this->mysqli->error . __LINE__);
		if ($r->num_rows > 0) {
			$result = $r->fetch_row();
			$this->response($result[0], 200);
		}
		$this->response('', 204);	// If no records "No Content" status
	}

	private function get_count_result($query)
	{
		$r = $this->mysqli->query($query) or die($this->mysqli->error . __LINE__);
		if ($r->num_rows > 0) {
			$result = $r->fetch_row();
			return $result[0];
		}
		return 0;
	}

	private function post_one($obj, $column_names, $table_name)
	{
		$keys 		= array_keys($obj);
		$columns 	= '';
		$values 	= '';
		foreach ($column_names as $desired_key) { // Check the recipe received. If blank insert blank into the array.
			if (!in_array($desired_key, $keys)) {
				$$desired_key = '';
			} else {
				$$desired_key = $obj[$desired_key];
			}
			$columns 	= $columns . $desired_key . ',';
			$values 	= $values . "'" . $this->real_escape($$desired_key) . "',";
		}
		$query = "INSERT INTO " . $table_name . "(" . trim($columns, ',') . ") VALUES(" . trim($values, ',') . ")";
		//echo "QUERY : ".$query;
		if (!empty($obj)) {
			//$r = $this->mysqli->query($query) or trigger_error($this->mysqli->error.__LINE__);
			if ($this->mysqli->query($query)) {
				$status = "success";
				$msg 		= $table_name . " created successfully";
			} else {
				$status = "failed";
				$msg 		= $this->mysqli->error . __LINE__;
			}
			$resp = array('status' => $status, "msg" => $msg, "data" => $obj);
			$this->response($this->json($resp), 200);
		} else {
			$this->response('', 204);	//"No Content" status
		}
	}

	private function post_update($id, $obj, $column_names, $table_name)
	{
		$keys = array_keys($obj[$table_name]);
		$columns = '';
		$values = '';
		foreach ($column_names as $desired_key) { // Check the recipe received. If key does not exist, insert blank into the array.
			if (!in_array($desired_key, $keys)) {
				$$desired_key = '';
			} else {
				$$desired_key = $obj[$table_name][$desired_key];
			}
			$columns = $columns . $desired_key . "='" . $this->real_escape($$desired_key) . "',";
		}

		$query = "UPDATE " . $table_name . " SET " . trim($columns, ',') . " WHERE id=$id";
		if (!empty($obj)) {
			// $r = $this->mysqli->query($query) or die($this->mysqli->error.__LINE__);
			if ($this->mysqli->query($query)) {
				$status = "success";
				$msg 	= $table_name . " update successfully";
			} else {
				$status = "failed";
				$msg 	= $this->mysqli->error . __LINE__;
			}
			$resp = array('status' => $status, "msg" => $msg, "data" => $obj);
			$this->response($this->json($resp), 200);
		} else {
			$this->response('', 204);	// "No Content" status
		}
	}

	private function delete_one($id, $table_name)
	{
		if ($id > 0) {
			$query = "DELETE FROM " . $table_name . " WHERE id = $id";
			if ($this->mysqli->query($query)) {
				$status = "success";
				$msg 		= "One record " . $table_name . " successfully deleted";
			} else {
				$status = "failed";
				$msg 		= $this->mysqli->error . __LINE__;
			}
			$resp = array('status' => $status, "msg" => $msg);
			$this->response($this->json($resp), 200);
		} else {
			$this->response('', 204);	// If no records "No Content" status
		}
	}

	private function responseInvalidParam()
	{
		$resp = array("status" => 'Failed', "msg" => 'Invalid Parameter');
		$this->response($this->json($resp), 200);
	}

	/* ==================================== End of API utilities ==========================================
		 * ====================================================================================================
		 */

	/* Encode array into JSON */
	private function json($data)
	{
		if (is_array($data)) {
			return json_encode($data, JSON_NUMERIC_CHECK);
		}
	}

	/* String mysqli_real_escape_string */
	private function real_escape($s)
	{
		return mysqli_real_escape_string($this->mysqli, $s);
	}
}

// Initiate Library
$api = new API;
if (isset($_GET['check_connection'])) {
	$api->check_connection();
} else if (isset($_GET['get_settings'])) {
	$api->get_settings();
} else if (isset($_GET['get_ads'])) {
	$api->get_ads();
} else if (isset($_GET['get_categories'])) {
	$api->get_categories();
} else if (isset($_GET['get_matchs'])) {
	$api->get_matchs();
} else if (isset($_GET['get_channels_by_cat'])) {
	$api->get_channels_by_cat();
} else if (isset($_GET['get_channel'])) {
	$api->get_channel();
} else {
	$api->processApi();
}
